/*******************************************************************************
 * Copyright (C) 2020 Sighthound, Inc. All rights reserved.
 * The information and source code contained herein is the
 * exclusive property of Sighthound, Inc. No part of this software
 * may be used, reproduced, stored or distributed in any form,
 * without explicit written authorization from Sighthound, Inc.
 ******************************************************************************/

declare namespace Sighthound.Api.Core {

/**
 * Timestamp in ISO presentation.
 *
 * @example
 * ```
 * 2020-07-01T16:42:05.285725Z
 * ```
 */
type Timestamp = string;

/**
 * To declare that the data provides `@type` field, something which can be used
 * e.g. for data validation or switching between different possible types.
 */
interface ITypeOf<V extends Sighthound.Api.VersionAll, P extends Sighthound.Api.Product, T extends string> {
    "@type": Sighthound.Api.Typed<V, P, T>;
}
type AnyTypeOf<P extends Sighthound.Api.Product> = ITypeOf<VersionAll, P, string>;

type Tag<T> = Record<string, T>;
type AnyTag = Tag<unknown>;

type InputUri = string | string[];

type InputContent = string | string[];

type Input = ({
    inputUri: InputUri;
    inputContent?: never;
} | {
    inputContent: string;
    inputUri?: never;
}) & {
    forceConversion?: boolean;
};

interface FetchTweaks {
    ignoreCertificateErrors?: boolean,
}

}
