/*******************************************************************************
 * Copyright (C) 2020 Sighthound, Inc. All rights reserved.
 * The information and source code contained herein is the
 * exclusive property of Sighthound, Inc. No part of this software
 * may be used, reproduced, stored or distributed in any form,
 * without explicit written authorization from Sighthound, Inc.
 ******************************************************************************/

declare namespace Sighthound.Api.Core.Notification {

/**
 * Events are the named events that trigger notifications.
 */
type Event =
    /**
     * The operation has been started, for example after being queued for a while.
     */
    "START" |
    /**
     * The operation's progress has increased, granularity depends on the system.
     */
    "PROGRESS" |
    /**
     * The operation has completed.
     */
    "COMPLETION";

interface IConfig extends Sighthound.Api.Core.FetchTweaks {

    /**
     * The method to use when sending a notification to the user's webhook.
     * POST is currently the only one supported.
     */
    method: "HTTP_POST" | "AMQP";

    /**
     * URI pointing to the receiving endpoint, e.g. for webhooks a URL like
     * https://example.local/notify, or for AMQP something like
     * amqp://example.local/vhost (plus further routing information).
     */
    uri: string;

    /**
     * Number of times to retry to send (for "HTTP_POST" method).
     */
    retries?: number;

    /**
     * Array of desired {@link Event} that trigger notifications.
     */
    events: Event[];
}

/**
 * Notification payload just consists of operation status payload, yet it is
 * recommended to use this type in case of future extensions.
 */
type Payload<P extends Sighthound.Api.Core.Product, R extends Sighthound.Api.Core.AnyTypeOf<P>> = Sighthound.Api.Core.Operation.Status<P, R>;

}
