/*******************************************************************************
 * Copyright (C) 2020 Sighthound, Inc. All rights reserved.
 * The information and source code contained herein is the
 * exclusive property of Sighthound, Inc. No part of this software
 * may be used, reproduced, stored or distributed in any form,
 * without explicit written authorization from Sighthound, Inc.
 ******************************************************************************/

declare namespace Sighthound.Api.Core.Operation {

/**
 * Operations are addressed through a path-like name, globally unique.
 *
 * @example
 * ```
 * projects/project-id/locations/location-id/operations/operation-id
 * ```
 */
type Name = string;

/**
 * Operations identifiers are globally unique, last element of a name.
 */
type Id = string;

interface IScope {
    projectId?: Sighthound.Api.ProjectId;
    locationId?: Sighthound.Api.LocationId;
}

interface IProgress {

    inputUri: Sighthound.Api.Core.InputUri;
    progressPercent: number;
    startTime: Sighthound.Api.Core.Timestamp;
    updateTime: Sighthound.Api.Core.Timestamp;
}

/**
 * The results of a completed, successful, operation where the data made available
 * through some means, either inline or remote, see {@link IStoredProcessResult}.
 */
interface IProcessResponse<V extends VersionAll, P extends Product, R> extends Sighthound.Api.Core.ITypeOf<V, P, "ProcessResponse"> {
    processResult: R;
}

interface IStoredProcessResult {
    outputUri: string;
}

type StoredProcessResponse<V extends VersionAll, P extends Product, R extends IStoredProcessResult> = IProcessResponse<V, P, R>;

interface IErrorStatus<P extends Product> {
    code: 0 | 1 | 2 | 429;
    message: string;
    details: (Sighthound.Api.Core.AnyTypeOf<P> & { [key: string]: unknown; })[];
}

type Outcome<P extends Product, R extends Sighthound.Api.Core.AnyTypeOf<P>> = {
    response: R|R[];
    error?: never;
} | {
    error: IErrorStatus<P>;
    response?: never;
};

/**
 * The current status of a operation.
 * Progress can be queried or is published while the operation is running.
 * When it's done, an error or response will exist.
 */
type Status<P extends Product, R extends Sighthound.Api.Core.AnyTypeOf<P>> = Partial<Outcome<P, R>> & {

    name: Name;

    metadata: Sighthound.Api.Core.ITypeOf<Version11, P, "Progress"> & {
        progress: IProgress;
        tag?: Sighthound.Api.Core.AnyTag;
    };

    done: boolean;
}

}