/*******************************************************************************
 * Copyright (C) 2024 Sighthound, Inc. All rights reserved.
 * The information and source code contained herein is the
 * exclusive property of Sighthound, Inc. No part of this software
 * may be used, reproduced, stored or distributed in any form,
 * without explicit written authorization from Sighthound, Inc.
 ******************************************************************************/

declare namespace Sighthound.Api {

/**
 * Project identifier.
 */
type ProjectId = string;

/**
 * Location identifier.
 */
type LocationId = string;

/**
 * Original API version.
 */
type Version1 = 1;

/**
 * Some recent updates be made (backwards compatible, still).
 */
type Version11 = 11;

/**
 * All offical version numbers.
 */
type VersionAll = Version1 | Version11;

/**
 * Known product names.
 */
type Product = "core" | "cloud" | "redactor";

/**
 * To created an `@type` expression for request/response payload.
 */
type Typed<V extends VersionAll, P extends Product, T extends string> = `sighthound.${P}.v${V}.${T}`;

}