/*******************************************************************************
 * Copyright (C) 2024 Sighthound, Inc. All rights reserved.
 * The information and source code contained herein is the
 * exclusive property of Sighthound, Inc. No part of this software
 * may be used, reproduced, stored or distributed in any form,
 * without explicit written authorization from Sighthound, Inc.
 ******************************************************************************/

declare namespace Sighthound.Metadata {

type HashType = "md5" | "sha1" | "sha256" | "sha512";

type System = Partial<{
    sio_file_name: string;
    sio_file_size: number;
    sio_file_time_acquired: number;
    sio_video_duration: number;
} & {
    [key in `sio_file_${HashType}`]: string
}>;

type Etc<C> = Partial<{
    etc_media_title: string,
    etc_media_path: string[];
    etc_event_webhook: string;
    etc_event_webhook_ignore_certificate_errors: boolean;
    etc_customize: C;
}>;

type Custom<T> = Partial<{

    /**
     * Example entry for a custom metadata item called `default` as it needs to be presented to
     * be both recognized as such (prefix of `custom_`) as well as an (optional) key title string
     * declared by an I18N suffix, e.g. `__en_US` being the equivalent of an `en-US` translation.
     * If no title is given any presentation logic should simply use the part after `custom_`,
     * unless the internal I18N solution has keys and translations explicitly provisioned.
     */
    custom_example: T;
    custom_example__en_US: string;
}>;

type Collection<C> = System & Etc<C> & Custom<unknown>;
type CustomCollection = Collection<unknown> & Partial<Record<string, unknown>>;

}
